using System;
using System.Collections.Generic;
namespace Kvalifikacije2DrugiZad
{
	class Frilenser
	{
		public double Zarada;
		public double PrihvatljivPorez;
		public Frilenser(double zarada, double prihvatljivPorez)
		{
			Zarada = zarada;
			PrihvatljivPorez = prihvatljivPorez;
		}
	}
	class Program
	{
		static double Zarada(double porez, List<Frilenser> frilenseri)
		{
			double ret = 0;
			foreach(Frilenser f in frilenseri)
			{
				if(f.PrihvatljivPorez >= porez)
				{
					ret += f.Zarada * porez / 100.0;
				}
			}
			return ret;
		}
		static void Main(string[] args)
		{
			List<Frilenser> frilenseri = new List<Frilenser>();
			int n = int.Parse(Console.ReadLine());
			for (int i = 0; i < n; i++)
			{
				string[] input = Console.ReadLine().Split();
				frilenseri.Add(new Frilenser(double.Parse(input[0]),double.Parse(input[1])));
			}
			double maxZarada = double.MinValue;
			foreach(Frilenser f in frilenseri)
			{
				double zarada = Zarada(f.PrihvatljivPorez, frilenseri);
				if (zarada > maxZarada)
				{
					maxZarada = zarada;
				}
			}
			Console.WriteLine(maxZarada);
		}
	}
}